# HOWTO live-build stretch : travaux pratiques

*retranscription corrigée de la session de travail du 20 mai 2017 sur le chan ##DFL-apprentissage de freenode*  
*animateur : arpinux -- relecture et corrections : kyodev*  
*[logs bruts disponibles](https://git.framasoft.org/dflinux/DFiso/blob/master/doc/2017_05_19-session-apprentissage.log) dans les sources du projet DFLinux*

Bonsoir et bienvenue dans la session de simulation de construction d'une ISO personnalisée Debian :D  
But de la session de travail : décomposer la personnalisation et suivre les modifications apportées aux sources du build au fur et à mesure.

je vais partir d'un live vide puis ajouter par section les différents éléments.  
pour l'exemple, je ne construirai pas de live compatible UEFI, car l'option est encore en travaux,
et le but principal est de bien suivre une construction, pas de tester la compatibilité UEFI :)

vous pourrez personnaliser plus finement votre environnement après la session.
je ne rajouterais que peu d'éléments, ceux qui me semblent les plus pertinents pour commencer avec live-build.

les sources utilisées pour cette session [sont disponibles ici](https://git.framasoft.org/dflinux/DFiso/blob/master/doc/HOWTO-livebuild-stretch-TP.zip)

notez que le processus simulé ce soir n'est pas fixé et que ce n'est qu'un exemple ... vous êtes libre ! :D

## Premiers scripts de configuration

la première chose à ajouter dans les sources d'un build, ce sont les premiers scripts de config et de construction situés dans le dossier __/auto__ des sources :

- le fichier '__build__' est celui livré par défaut dans live-build

```
#!/bin/sh

set -e

lb build noauto "${@}" 2>&1 | tee build.log
```

- le fichier '__clean__' est modifié pour nettoyer plus et pour y voir plus clair sur les modifications des sources

```
#!/bin/sh

lb clean noauto "$@"
rm -f config/binary config/bootstrap config/build \
      config/chroot config/common config/source \
      config/package-lists/live.list.chroot
find config/hooks/ -type l | xargs --no-run-if-empty rm -f

```

- le fichier '__config__', script qui va définir les arguments lancés à lb build

```
#!/bin/sh
#############################
lb config noauto \
    --mode "debian" \
    --system "live" \
    --architectures "i386" \
    --distribution "stretch" \
    --archive-areas "main contrib non-free" \
    --security "true" \
    --updates "true" \
    --backports "false" \
    --binary-filesystem "fat32" \
    --binary-images "iso-hybrid" \
    --apt-indices "true" \
    --apt-recommends "true" \
    --apt-secure "true" \
    --apt-source-archives "false" \
    --linux-package "linux-image" \
    --bootloader "syslinux" \
    --debian-installer "live" \
    --debian-installer-gui "true" \
    --win32-loader "false" \
    --clean \
    --verbose \
    --source "false" \
	"${@}"

```

pour la liste complète des options acceptées, un `man lb config` vous renseignera.
le but de cette session est vraiment d'en faire le minimum pour un résultat optimal.

dans les options indiquées dans auto/config, on remarque la ligne "architecture"
qui permet de construire un live avec une architecture différente de celle du système hôte.

notez qu'il n'est pas possible de builder une amd64 depuis un i386 mais l'inverse, oui.

la liste complète des options est disponible dans le man, mais il n'est pas totalement à jour
donc pour vérifier celles que vous voudriez modifier dans les sources de ce soir,
on peut se reporter au fameux "test à vide" effectué hier et dont il est question
dans le *HOWTO-livebuild-stretch* ou simplement se contenter de celui que je fournis
et qui vous permettra de builder sereinement sans trop vous poser de questions au début :)

## Applications à installer

la suite de la personnalisation réside dans les applications à installer

ce soir, on va faire simple, on va coller les mêmes applis dans le live et dans le système final.
mais il est possible de séparer les paquets pour avoir des applications en plus ou en moins dans le live et le système installé.

donc la liste des paquets se trouve dans le dossier __config/package-lists/__
les paquets listés sont pris en charge par apt, donc nul besoin des dépendances.
alors effectivement, on pourrait encore simplifier et vous pourrez le faire.

il y a deux listes:

la liste __live-*__ a été ajoutée automatiquement par live-build.
elle contient des paquets présents dans le live mais qui ne seront pas installés sur le disque dur.

```
live-boot
live-config
live-config-systemd

```

vous comprenez que vous pouvez éditer cette liste, donc cette liste __live-*__ est ajoutée par live-build
mais vous pouvez en coller une autre

en fait tout fichier placé ici __/config/package-lists/live-*__ avec l'extension __.chroot__
sera pris en compte par live-build et en place dans la session live, mais pas dans le système installé.

les autres listes (sans *live*) servent pour les paquets du live qui seront installés sur le système.
vous pouvez faire des listes à thème si vous voulez genre _multimedia.list.chroot_ ...

bref la seconde liste avec les applications,
elle est détaillée car je n'ai pas mis de gros méta-paquets

```
#base
task-french-desktop task-french task-print-server
lsb-release acpi accountsservice
bash bash-completion command-not-found

#login
lightdm lightdm-gtk-greeter lightdm-gtk-greeter-settings

#desktop
xfce4 xfce4-terminal xfce4-notifyd xfce4-settings xfce4-taskmanager
xarchiver xfburn

#plugins
xfce4-battery-plugin xfce4-cpugraph-plugin xfce4-datetime-plugin 
xfce4-mount-plugin xfce4-mailwatch-plugin xfce4-xkb-plugin
xfce4-places-plugin xfce4-power-manager-plugins
xfce4-screenshooter xfce4-notes-plugin xfce4-whiskermenu-plugin

#filer
thunar thunar-archive-plugin thunar-volman tumbler tumbler-plugins-extra

#network
firefox-esr firefox-esr-l10n-fr
transmission-gtk network-manager-gnome gnome-nettool ntp curl wpasupplicant

#office
system-config-printer simple-scan
mousepad evince hplip-gui

#media
vlc gstreamer1.0-fluendo-mp3 gstreamer1.0-plugins-bad gstreamer1.0-plugins-ugly
pavucontrol

#graphics
ristretto

#system
vrms gdebi gnome-system-tools gnome-keyring synaptic
gnome-disk-utility gdisk dosfstools ntfs-3g ntfs-config mtools e2fsprogs

#tools
catfish zenity zip p7zip-full htop most ncdu baobab
dvd+rw-tools python-apt xdotool eject deja-dup blueman

#misc
gvfs gvfs-fuse fusesmb gvfs-backends x11-utils x11-apps xcalib

#doc
manpages-fr debian-reference-fr

#theme
gnome-brave-icon-theme murrine-themes gtk3-engines-xfce arc-theme

#nonfree
flashplugin-nonfree firmware-b43-installer firmware-b43legacy-installer libdvdcss2
b43-fwcutter firmware-linux firmware-linux-nonfree alsa-firmware-loaders firmware-ralink
intel-microcode iucode-tool ttf-mscorefonts-installer ttf-xfree86-nonfree unrar
```

le système des dépendances debian permet de réduire la liste à 5 ou 6 paquets grâce aux __"task-*"__,
mais ça fait des live assez gros, comme les lives officiels en fait.

donc pour éviter ça, on ne colle pas des trucs genre gnome-desktop :)  
mais plutôt les composants séparés. je vous invite à ouvrir cette liste __madebian.list.chroot__

vous pouvez supprimer ou ajouter des applications en prenant soin de vérifier qu'elles se trouvent bien dans les dépôts stretch :)

la liste d'origine fournie donne un temps de build de 2h en gros, avec un système final fonctionnel
bureau xfce/firefox/transmission/cups ... le nécessaire :)

mais je vous laisse quelques minutes pour bien mater le fichier, et le modifier à votre guise
vous pouvez y aller, ça ne gênera pas la suite des ajouts, quoique vous modifiez :)

## Bannière de l'installeur

passons à une truc débile et rigolo, la bannière de l'installeur graphique :)

car oui donc, avant de taper dans les trucs longs et embêtant, un petit plaisir
de custo, la bannière le truc qui va s'afficher en haut pendant l'installation
et qui dira "tu installes ma distro" :D

un peu d'ego ne fait pas de mal si il ne fait pas d'ombre à l'autre :)

c'est dans le dossier __config/includes.installer/usr/share/grahics/__
oui, je sais, c'est futile mais ça rassure aussi l'utilisateur de savoir que le
buildeur s'est un peu fait chier à personnaliser son truc et n'a pas juste balancé
2 walls et 3 applis :) c'est pas anodin :)

vous trouverez un exemple [dans l'archive dédiée](https://git.framasoft.org/dflinux/DFiso/blob/master/doc/HOWTO-livebuild-stretch-TP.zip) à ces travaux pratiques

## Menu de démarrage du liveCD/DVD/USB

passons à plus sérieux, le menu de boot du live.  
il est contrôlé par syslinux. pour le personnaliser, vous pouvez changer les labels
des entrées , le fond et même en rajouter par exemple:  
lister plusieurs entrées avec différentes langues activées par défaut
car les options passées à syslinux sont comme les options de grub
on va voir de suite une customisation simple :  
ça se passe dans __/config/includes.binary/isolinux/__ . le nouveau dossier intègre
un menu pour le live et un fond d'écran mais vous pouvez aussi personnaliser le label
d'installation, le titre principal, etc.  
donc le fichier '__live.cfg__'

```
label live
	menu label ^Tester Debian
    menu default
	linux /live/vmlinuz
	initrd /live/initrd.img
	append boot=live components quiet splash locales=fr_FR.UTF-8 keyboard-layouts=fr keyboard-variants=oss 

label live-failsafe
	menu label T^ester Debian (mode sans echec)
	linux /live/vmlinuz
	initrd /live/initrd.img
	append boot=live components noapic noapm nodma nomce nolapic nomodeset nosmp nosplash vga=normal locales=fr_FR.UTF-8 keyboard-layouts=fr keyboard-variants=oss 
```

vous pouvez voir que ce fichier contient le label "tester debian" en premier avec un ^,
c'est pour indiquer la touche d'accès rapide au clavier, le raccourci quoi ...

la dernière ligne de chaque section indique les options passées au kernel `append boot = ...`  
c'est là que vous pouvez spécifier la langue du live

le fichier '__install.cfg__' n'est pas dans ces sources car on ne le personnalise pas,
il sera ajouté par live-build et donc, on aura bien une entrée 'install' dans le menu final :)

pour les couleurs, la disposition, etc, franchement, c'est la galère car c'est tout en code de taré  
(_terme technique assumé_)  
donc faites simple, ce sera mieux :)

et puis, ce n'est pas non plus le plus important, le tout étant d'avoir au moins la bonne langue au démarrage :)

## Personnalisation directe de l'environnement

on va attaquer maintenant le plus cool, la customisation directe du système et du user.

ça se passe dans __/config/includes.chroot/__

ce dossier représente la racine du système installé :)

donc c'est le moment de se faire plaisir et d'y ajouter tout ce qu'on veut :)
avec quelques restrictions cependant :

### attention...

_badadd n1_  
__les trucs écrasés...__   
si vous ajoutez dans ce dossier, un élément qui appartient déjà à un paquet,
il sera écrasé par le paquet lors du build

par exemple, vous voulez coller votre version de "ffmpeg", mais si vous ajoutez
_config/includes.chroot/usr/bin/ffmpeg_, il sera écrasé par le vrai lors de la prochaine
mise à jour. vous pouvez coller le vôtre dans /usr/local/bin :)

il ne sera pas écrasé et vous pourrez vous en servir sans soucis depuis un alias approprié :)

_badadd n2_  
__le paquets perso__   
live-build gère ses paquets avec apt, donc dépendances, sécurité, mise à jour et tout ce qui va bien

live-build vous permet d'ajouter des paquets perso dans le dossier __/config/packages__
c'est super :)

mais attention, les dépendances ne sont pas prises en compte car c'est dpkg qui agit alors.
c'est dpkg qui installe les paquet de /packages donc avec tout ce que ça implique :)  
pas de suivi des mises à jour et pas de gestion des dépendances, donc faire attention...

_badadd n3_  
__les copyrights__  
gaffe si vous voulez diffuser votre live, ce que vous y ajoutez est de votre responsabilité,
donc respectez les licences, créditez les auteurs, placez des liens dans un README

bref soyez responsables de ce que vous diffusez, je sais que ça fait un peu vieux con de dire ça
mais les débutants ou les curieux de linux méritent de recevoir un truc propre :)

ce n'est pas parce que c'est free et gratuit que ça doit être "_passable_" ;)

donc pour illustrer la customisation, un exemple tout bête, les wallpapers persos :)

bah oui ... c'est quand même super cool d'avoir ses walls dans sa distro :)  
vous trouverez les walls [dans l'archive dédiée](https://git.framasoft.org/dflinux/DFiso/blob/master/doc/HOWTO-livebuild-stretch-TP.zip) à ces travaux pratiques.

## Applications venant de dépôts externes

un point sur les paquets selon ceux que vous avez ajoutés/retirés. si comme dans les sources,
vous avez installé libdvdcss2, vous devez ajouter des dépôts externes

les paquets listés doivent être sur un dépôt, logique.  
si ils ne sont pas chez debian, il faut indiquer le dépôt + la clé d'authentification, soit en un commit pour faire simple

2 fichiers identiques pour les dépôts videolan : un pour le live et un pour le système installé

```
deb http://download.videolan.org/pub/debian/stable/ /
```

2 fichiers identiques pour la clé videolan : idem que pour l'autre :)

```
-----BEGIN PGP PUBLIC KEY BLOCK-----
Version: GnuPG v1.4.12 (GNU/Linux)

mQENBFIcm2kBCADL5XxrZ27r2z3qqV6r3FUfg90UvM58wvxryAaoXr+y+W0Joh/m
7+Vtxv0DBekTrACuGy7Vg1NzsFHNzEuAbPctpbZgffNSwxgrToFERenEbF14f7Ff
xDkF3vLgyll5frNozE2csAaj19lTQLBTNZbhkEys0V844zQSDN9/UYp5BWWXRFt8
xHtocGayloFPdVOcWA+B8gO6hBWyZa7QaMKVvzEiHyqzmxVINJ1k1P3PFqMuHGOF
JsPY4ARRZzQ+JYfrtgoqtAh9LYMQAfKmn7F3nlQyUuocEsKuhS0kIDtvLxTdjkef
ZYcmQXWxPSxUan6lqP3LGrkMdEmLrzwnFkujABEBAAG0MFZpZGVvTEFOIEFQVCBT
aWduaW5nIEtleSA8dmlkZW9sYW5AdmlkZW9sYW4ub3JnPokBOAQTAQIAIgUCUhyb
aQIbAwYLCQgHAwIGFQgCCQoLBBYCAwECHgECF4AACgkQa8peTbhCiNk7HQgAyy/H
Oyzk0UdrFv0bZgqZLxJcdB7ctcruYNkO0eZE09+sPjzBuX52sx6GuXElG/NUw/Qo
GUB5kDDKLyeddpyQghU7UhsIZoNdSb2UfVCqSosJ1G7dacRlVh5LFNF1ptYjXGza
NIp0zme8YtoQKVCO48YYIf+j94Q5AukTEd1vdPAUAm7e4Q6uYcvpyz1TIoZgnnO/
/fcoWPQrRHnxfsIB0GrqVkHncjt/U1qsxQh7hAJnKjwgnveUe7Q2ey54QId9BQWZ
HOxeIXpbhFGwBmHxBGAnDWmg557YlsUI4ejiKy6DBsO8h91NL44cbN8H61Z+T3UH
NWXycr/4PClWZEitkYhGBBARAgAGBQJSHJxcAAoJEGFgnhjAr/EP+DAAmwfLrnFE
ktmlOv8YssNOBlCh8cEvAJ9qPJoCbY4tWZtaC6aa4R2owLsSoohGBBARAgAGBQJS
HJxpAAoJEHGAcTvljRrcaywAn3Gf8fHXVdgpCrycr584Iie1+mEyAKCR8V9kt5DW
F6VGUXbhV9INKSKCKbkBDQRSHJtpAQgAw4TQFpFs9PthvzTj/fpa6rioz2gYIGxG
TQHuC8LsOCEKuy4AFa8XF2d89NM7ApF/ixU3QDKd7I6YydkW/yp3rTCbnI+xS649
yxDd2RDIqVPsqjWuO8jEs8sQ/wOWMnDdCU95Zwv0BU491u63UbRzamv5+kw7QGQq
Pe4VAnsiVxwnV1GOa9Ft0FmaD/m7KhFWAGkTF3pV432gH93V8srPZD+CWZgld97E
45TXXjzWK03NnUyIK+rx+LHJf4I8IFFP0F77FJDIFRJ6BiYbXoKNDVk/nvy1jWg5
98dFi7jzw1t83EnAVgTvBR+bQqBpB69EtY2WUykABMnjMj9t0Y6eFwARAQABiQEf
BBgBAgAJBQJSHJtpAhsMAAoJEGvKXk24QojZNMIH/3YE92QZ22YYdl6TchMDswsB
FXvsS2/W0xhvKvG5YuyCKoUKYCornK74YrsRURAhYAOvOfrcWeq+wtmUmXrhNvZ2
Qz370hS2EW6Db7FnMdu188LrVZS0AmC1ztu8/DlwRcRF4e05CVgwUMngG2RiAuZN
1ZYQiHJwU2444/Vm+ny/YD55I+RUmKFW69iAvWnJrz5QzohoeZefr48c3FU1glKY
E3OtJK/T+/nOVzt+Kzjw8mmrtkZqck/ZVpA51ikcTRSpyLw5ioLpzLFbB/Ew+Dx3
CzFOZhG9UxBV08BOw9a30090OhxPDoKBu210T3tBW9XWmFPohT2fsg5OXZHvp/Q=
=pGjl
-----END PGP PUBLIC KEY BLOCK-----

```

donc si vous voulez par exemple, le dépôt TOR, vous ajoutez les dépôts sous forme
d'adresse + le fichier avec la clé dans le même dossier avec les mêmes extensions
__*.binary__ pour le live et __*.chroot__ pour le système installé.

donc c'est fini pour la customisation de base ...

## Personnalisation de la session utilisateur

et oui, ça suffit pour faire un live déjà :D

pour un premier build fonctionnel , pas de custo du user en phase 1.  
pourquoi?  
car il faut d'abord choper les valeurs par défaut avant de les modifier,
les valeurs distribuées par le système que vous venez de créer.

donc le meilleur moyen, c'est de builder  
lancer le live  
personnaliser en live  
puis faire une archive des mods donc généralement archiver le ~/.config,
le ~/.mozilla si vous voulez mais __attention à bien vider le cache et les pass__ !!!  
puis récupérer ces archives pour les placer des __includes.chroot/etc/skel__ afin de personnaliser votre utilisateur :)
et vous retrouverez vos préférences en live

autre solution, pour la customisation user, si vous utilisez le même environnement que celui qui sera dans le live
vous pouvez récupérer certaines de vos préférences directement

attention, pensez que le live, s'il est public, comportera vos préférences...donc pas de .ssh  

__PAS DE .SSH !!!__

bref, je ne peux pas lister vos fichiers sensibles mais vous avez compris le principe :)  
et c'est aussi pour ça que pour ce soir, je ne vous conseille pas de customiser le user,
autant vous concentrer sur les applications à installer,  
donc si vous êtes partant, on peut **lb build** :D

## Construction du live

depuis les sources, vous pouvez envoyer la commande `sudo lb build`

## Conclusion

donc voilà, [avec ces sources](https://git.framasoft.org/dflinux/DFiso/blob/master/doc/HOWTO-livebuild-stretch-TP.zip),
vous avez une armature pour un live simple sur xfce,
que vous pouvez agrémenter avec le tuto live-build et faire votre distro.

j'espère avoir été clair et simple et que vous avez vu le processus en global :)
